Imports System.Collections

' Delegacja dla zadania zliczania modyfikacji
Public Delegate Function ModificationCountDelegate() As Long

' Wsplna, abstrakcyjna klasa bazowa dla dziedziczcych po niej klas Iterator
Public MustInherit Class AbstractEnumerator
    Implements IEnumerator

    ' Dany obiekt bdzie wykorzystywa delegacj do uzyskiwania
    ' wartoci licznika modyfikacji struktury danych, za ktrej
    ' obsug odpowiada. Za kadym razem, gdy ta struktura danych
    ' jest modyfikowania, licznik powinien by zwikszany o jeden.
    Private getModificationCount As ModificationCountDelegate

    ' Licznik modyfikacji reprezentujcy liczb zmian dokonanych na
    ' obsugiwanej strukturze danych w momencie utworzenia tego obiektu.
    Private originalCount As Long

    ' Reprezentuje biec skadow struktury danych bdcej przedmiotem
    ' nawigacji.
    Private myCurrent As Object = Nothing

    ' Jeli ta skadowa ma warto true, waciwo reprezentujca biecy element
    ' nie jest odwzorowaniem adnej skadowej obsugiwanej struktury danych.
    Private currentIsMapped As Boolean = False

    ' Konstruktor
    Public Sub New(ByVal theDelegate As ModificationCountDelegate)
        getModificationCount = theDelegate
        originalCount = getModificationCount()
    End Sub

    ' Bieca skadowa obsugiwanej struktury danych.
    '
    ' Generuje wyjtek System.InvalidOperationException,
    ' jeli bieca pozycja w strukturze danych nie
    ' wskazuje na aden element. Taka sytuacja moe mie
    ' miejsce bezporednio po utworzeniu obiektu, po
    ' zwrceniu wartoci false przez jego metod MoveNext
    ' lub po wywoaniu metody Reset.
    Public ReadOnly Property Current() As Object Implements IEnumerator.Current
        Get
            If Not currentIsMapped Then
                Dim msg As String
                msg = "Brak biecej skadowej struktury danych."
                Throw New System.InvalidOperationException(msg)
            End If
            Return myCurrent
        End Get
    End Property

    ' Ma warto true, jeli obsugiwana struktura danych zostaa zmodyfikowana.
    Public ReadOnly Property InvalidFlag() As Boolean
        Get
            Return getModificationCount() <> originalCount
        End Get
    End Property

    ' Generuje wyjtek, jeli obsugiwana struktura danych
    ' zostaa zmodyfikowana.
    Private Sub CheckModified()
        If InvalidFlag Then
            Dim msg As String = "Obsugiwana struktura danych zostaa zmodyfikowana."
            Throw New System.InvalidOperationException(msg)
        End If
    End Sub 'CheckModified

    ' Niniejsza funkcja odpowiada za przechodzenie do kolejnego
    ' elementu skadowego obsugiwanej struktury danych.
    ' obj - zmienna, ktrej zostanie przypisany nowy element.
    ' Zzwraca: true, jeli przejcie (nawigacja) do kolejnej
    ' skadowej struktury danych zakoczy si pomylnie, lub false,
    ' jeli wczeniej osignito ostatni skadow tej struktury.
    Protected MustOverride Function NextElement(ByRef obj As Object) As Boolean

    ' Przenosi wskanik do nastpnej skadowej obsugiwanej
    ' struktury danych.
    '
    ' Zzwraca: true, jeli rzeczywicie uda si przej do
    ' kolejnego elementu struktury danych, lub false, jeli
    ' wczeniej osignito ostatni skadow tej struktury.
    ' Generuje wyjtek System.InvalidOperationException, jeli
    ' obsugiwana struktura danych zostaa zmodyfikowana.
    Public Function MoveNext() As Boolean Implements IEnumerator.MoveNext
        CheckModified()
        currentIsMapped = NextElement(myCurrent)
        Return currentIsMapped
    End Function 'MoveNext

    ' Przechodzi do punktu poprzedzajcego pierwsz skadow
    ' obsugiwanej struktury danych.
    Protected MustOverride Sub ResetImpl()

    ' Przechodzi do punktu poprzedzajcego pierwsz skadow
    ' obsugiwanej struktury danych.
    ' Zwraca wyjtek System.InvalidOperationException,
    ' jeli obsugiwana struktura danych zostaa zmodyfikowana.
    Public Sub Reset() Implements IEnumerator.Reset
        CheckModified()
        ResetImpl()
    End Sub 'Reset
End Class 'AbstractEnumerator
